//---------------------------------------------------------------------------
// Sample code for uM-FPU64 64-bit FLoating Point Coprocessor
// Micromega Corporation  www.micromegacorp.com
// Author: Cam Thompson
//
// @file    Read_GPRMC2
// @target  Arduino
//
// This example provides a simple demonstration of reading GPS data using the
// uM-FPU64 64-bit floating point coprocessor. It reads latitude and longitude
// from the first GPRMC sentence and displays it on the Serial Monitor.
//
// It requires the functions contained one of the following FPU files be
// programmed into the uM-FPU64 Flash memory:
//   Read_GPRMC-demo3.fp4
//
// The GPS serial input is connected to the digital pin specified by GPS_PIN
// in the FPU file (default assignment is D0).
//
// @version
//  Mar 22, 2013
//  - original version for uM-FPU64
//---------------------------------------------------------------------------

#include <SPI.h>
#include <Fpu64.h>
#include <FpuSerial64.h>

//-------------------- uM-FPU Register Definitions -----------------------------
#define time    10                      // uM-FPU register
#define latitude    140                 // uM-FPU register
#define longitude   141                 // uM-FPU register

//-------------------- uM-FPU Function Definitions -----------------------------
#define enable_GPS  0                   // uM-FPU user function
#define read_GPRMC  1                   // uM-FPU user function
#define disable_GPS 2                   // uM-FPU user function
#define NMEA_to_degrees 3               // uM-FPU user function
#define UTCtime 4                       // uM-FPU user function

//-------------------- setup ------------------------------------------------

void setup()
{
  Serial.begin(9600);                   // print program title
  Serial.println();
  Serial.println("\nRead_GPRMC2");
  
  SPI.begin();                          // initialize SPI and FPU
  Fpu.begin();

  if (Fpu.sync() == SYNC_CHAR)          // print FPU version
    FpuSerial.printVersionln();
  else
  {
    Serial.print("uM-FPU not detected");
    while(1) ;                          // stop if FPU not detected
  }

  Fpu.write(FCALL, enable_GPS);         // enable GPS input
  Serial.print("Waiting for GPRMC sentence...");
  
  for (int cnt = 0; cnt < 10; cnt++)
  {
    Fpu.write(FCALL, read_GPRMC);  // read lat/long from GPS
    Fpu.wait();
    
    Serial.println();
    FpuSerial.printStringln();          // display the GPRMC sentence
    
    Fpu.write(STRSET, 0);               // clear string buffer
    
    Serial.print("Time (msec): ");      // print results
    Fpu.write(SELECTA, time);
    FpuSerial.printLong(0);
    
    Serial.print(", Lat: ");  
    Fpu.write(SELECTA, latitude);
    FpuSerial.printFloat(149);
    
    Serial.print(", Long: ");  
    Fpu.write(SELECTA, longitude);
    FpuSerial.printFloat(149);
  }  

  Fpu.write(FCALL, disable_GPS);        // disable GPS input
  Serial.print("\nDone.");
}

//-------------------- loop -------------------------------------------------

void loop()
{ 
}

